#include <windows.h>
#include "doc.h"
#include "..\debug.h"
#include "..\Application.h"

#pragma warning( disable : 4355 )
#if defined(CRT_FILE_IO)
CDocument::CDocument(LPOLEOBJECT lpObj, LPDATAOBJECT lpdata, LPDISPATCH lpdisp, LPSTORAGE lpStg, LPSTREAM lpStm, FILE* file) :
#else
CDocument::CDocument(LPOLEOBJECT lpObj, LPDATAOBJECT lpdata, LPDISPATCH lpdisp, LPSTORAGE lpStg, LPSTREAM lpStm, HANDLE file) :
#endif
CClientSite(this), CAdviseSink(this), CDispatch(this), CUIWindow(this),
m_Object(lpObj), m_ActiveObj(NULL), m_disp(lpdisp), m_pStg(lpStg), m_pStm(lpStm), m_cRef(0), m_file(file), m_fInitialize(false)
{
	DEBUGTRACE("In CDocuments' ctor");
#if 0
	m_Object->AddRef();
	m_disp->AddRef();
#endif
	if (m_pStg)
		m_pStg->AddRef();
	if (m_pStm)
		m_pStm->AddRef();
}

CDocument::~CDocument()
{
	DEBUGTRACE("In CDocuments' dtor");
}

bool _stdcall CDocument::Init(LPPERSISTSTREAMINIT lpPersist)
{
#if 0	
	HRESULT hr = lpPersist->InitNew();
	hr = m_Object->Advise(static_cast<LPADVISESINK>(this), &m_dwAdvise);
#endif
//	ReadFile
	m_fInitialize = true;
	return true;
}


void _stdcall CDocument::FinalRelease()
{
#if 0
	HRESULT hr = m_Object->Unadvise(m_dwAdvise);
#endif
#if 0
	HRESULT hr = m_Object->Release();
	hr = m_disp->Release();
#endif
	if (m_pStm)
		RELEASEINTERFACE(m_pStm);
	if (m_pStg)
		RELEASEINTERFACE(m_pStg);
}

ULONG __stdcall CDocument::AddRef()
{
	DEBUGTRACE(_T("In CDocument::AddRef recounts = %i"), m_cRef+1);
	return InterlockedIncrement(reinterpret_cast<PLONG>(&m_cRef));
}

ULONG __stdcall CDocument::Release()
{
	DEBUGTRACE(_T("In CDocument::Release recounts = %i"), m_cRef-1);
	_ASSERT(m_cRef > 0); // not thread safe
	if (InterlockedDecrement(reinterpret_cast<PLONG>(&m_cRef)) == 0)
	{
		delete this;
		return 0;
	}
	
	return m_cRef;
}

HRESULT __stdcall CDocument::QueryInterface(REFIID iid, PVOID *ppObj)
{
#if defined(_DEBUG)
	LPWSTR lpstrIID;
	StringFromIID(iid, &lpstrIID);
	DEBUGTRACE("In CDocument::QueryInterface has been asked for %S", lpstrIID);
	CoTaskMemFree(lpstrIID);
#endif

	if (iid == IID_IUnknown || iid == IID_IOleClientSite)
		*ppObj = (LPOLECLIENTSITE)this;
	else if (iid == IID_IDispatch || iid == DIID_ApplicationEvents)
		*ppObj = (LPDISPATCH)this;
	else if (iid == IID_IAdviseSink)
		*ppObj = (LPADVISESINK)this;
	else if (iid == IID_IPropertyBag)
		*ppObj = (LPPROPERTYBAG)this;
	else if (iid == IID_IOleInPlaceUIWindow)
		*ppObj = (LPOLEINPLACEUIWINDOW)this;
	else if (iid == IID_IOleWindow)
		*ppObj = (LPOLEWINDOW)this;
	else
	{
		*ppObj = NULL;
		return E_NOINTERFACE;
	}

	if (*ppObj) 
		reinterpret_cast<LPUNKNOWN>(*ppObj)->AddRef();
	
	return S_OK;
}


HRESULT __stdcall CDocument::Read(LPCOLESTR propName, LPVARIANT pVar, LPERRORLOG pErrLog)
{
/*TODO:
 *
 * Need to figure out how to store the properties in IPropertyBag::Write() so that they can be read correctly here
 *
 */
	CHECKPOINTER(propName);
	CHECKPOINTER(pVar);
	
	VARTYPE vt;
	BSTR propValue = NULL;;
	if (!m_fInitialize)
	{
		DEBUGTRACE("Warning CDocument::Init() has not been called");
		return E_UNEXPECTED;
	}
	
	ReadFile(propName, &propValue);
	_ASSERT(propValue);

#if 0	
	VARIANT v;
	VariantInit(&v);
	V_VT(&v) = VT_BSTR;
	V_BSTR(&v) = propValue;
	vt = V_VT(pVar);
	VariantInit(pVar);
	HRESULT hr = VariantChangeType(pVar, &v, 0, vt);
	_ASSERT(SUCCEEDED(hr));	
	SysFreeString(propValue);
#else
	V_BSTR(pVar) = propValue;
	vt = V_VT(pVar);
	V_VT(pVar) = VT_BSTR;
	HRESULT hr = VariantChangeType(pVar, pVar, 0, vt);
	_ASSERT(SUCCEEDED(hr));	
	SysFreeString(propValue);
#endif
	
	return S_OK;
}

HRESULT __stdcall CDocument::Write(LPCOLESTR propName, LPVARIANT pVar)
{
/*TODO:
 *
 * Need to figure out how to store the properties 
 *
 */

	CHAR_CONVERSION;
	CHECKPOINTER(propName);
	CHECKPOINTER(pVar);
	
	VARIANT v;
	char buffer[256];
	int len;
	DWORD cb;

	VariantInit(&v);
	HRESULT hr = VariantChangeType(&v, pVar, 0, VT_BSTR);
	_ASSERT(SUCCEEDED(hr));	
	
	switch (V_VT(pVar))
	{
		case VT_BSTR:
			len = wsprintf(buffer, "%s\t\t=\t\t\"%s\"\n", W2A(propName), W2A(V_BSTR(&v)));
			break;
		default:
			len = wsprintf(buffer, "%s\t\t=\t\t%s\n", W2A(propName), W2A(V_BSTR(&v)));
	}

#if defined(CRT_FILE_IO)
	if (fputs(buffer, m_file) == EOF)
	{
		DEBUGTRACE("Error writing to file");
		int err = ferror(m_file);
		_ASSERT(0);
	}
#else
 

	if (!WriteFile(m_file, buffer, len, &cb, NULL))
	{
		DEBUGTRACE("Error writing to file");
		int err = GetLastError();
		_ASSERT(0);
	}

#endif
	VariantClear(&v);

	return S_OK;
}


//HACKHACK should be storing the properties in a table rather than reading the file each time
bool CDocument::ReadFile(LPCOLESTR propName, BSTR *propValue)
{
	CHAR_CONVERSION;
	char  buffer[256], *propNameA, *p;
	DWORD cb;


	*propValue = NULL;
	propNameA = W2A(propName);

#if defined(CRT_FILE_IO)	
	if (!fgets(buffer, sizeof(buffer), m_file))
	{
		DEBUGTRACE("CDocument::ReadFile fgets() returned NULL");
		return false;
	}

	do 
	{
		if (buffer[0] == '\'')
		{
			p = fgets(buffer, sizeof(buffer), m_file);
			continue;
		}

		p = strtok(buffer, " =\t\n");
		if (lstrcmpi(propNameA, p)==0)
		{
			p = strtok(NULL, " =\t\n");
			if (*p == '\"')
				p = strtok(p+1, " \""); // String found remove quotes

			*propValue = SysAllocString(A2W(p));
			break;
		}

		p = fgets(buffer, sizeof(buffer), m_file);
	}
	while (p); // && !feof(m_file) && !ferror(m_file)); 

	rewind(m_file);
#else
	if (!::ReadFile(m_file, buffer, 256, &cb, NULL))
	{
		DEBUGTRACE("CDocument::ReadFile fgets() returned NULL");
		return false;
	}
	_ASSERT(cb != 0);
	
	do
	{
		p = strtok(buffer, " =\t\n");
		do 
		{
			if (p[0] == '\'')
			{
				p = strtok(buffer, "\n"); // go to next line
				continue;
			}

			if (lstrcmpi(propNameA, p)==0)
			{
				p = strtok(NULL, " =\t\n");
				if (*p == '\"')
					p = strtok(p+1, " \""); // String found remove quotes

				*propValue = SysAllocString(A2W(p));
				break;
			}
			p = strtok(NULL, "\n");
			if (p) p = strtok(NULL, " =\t\n");

		}
		while (p); 
	}
	while (!::ReadFile(m_file, buffer, 256, &cb, NULL) && cb != 0);
	

	if (SetFilePointer(m_file, 0, 0, FILE_BEGIN) == ~0)
	{
		DEBUGTRACE("CDocument::ReadFile SetFilePointer returned an error");
		return false;
	}
#endif
	return true;
}